/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.console.internal.ui;

import com.aptana.console.ConsolePlugin;
import com.aptana.console.internal.expressions.ExpressionManager;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;

public class ConsoleStyledTextListener
implements LineStyleListener,
LineBackgroundListener {
    private ExpressionManager expressionManager = ConsolePlugin.getDefault().getExpressionManager();
    private StyledText control;

    public ConsoleStyledTextListener(StyledText control) {
        this.control = control;
        control.addLineStyleListener((LineStyleListener)this);
        control.addLineBackgroundListener((LineBackgroundListener)this);
    }

    public void dispose() {
        if (!this.control.isDisposed()) {
            this.control.removeLineStyleListener((LineStyleListener)this);
            this.control.removeLineBackgroundListener((LineBackgroundListener)this);
        }
        this.control = null;
    }

    public void lineGetStyle(LineStyleEvent event) {
        StyleRange[] styles;
        String lineText = event.lineText;
        if (lineText.length() != 0 && (styles = this.expressionManager.calculateStyles(event.lineOffset, lineText)) != null) {
            event.styles = styles;
        }
    }

    public void lineGetBackground(LineBackgroundEvent event) {
        Color lineBackground = this.expressionManager.calculateBackground(event.lineText);
        if (lineBackground != null) {
            event.lineBackground = lineBackground;
        }
    }
}

